/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.AbstractQueryContext;
import com.mckoi.database.DataTable;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.Database;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.FunctionLookup;
import com.mckoi.database.GrantManager;
import com.mckoi.database.QueryPlanNode;
import com.mckoi.database.TableName;
import com.mckoi.database.TransactionSystem;

public class DatabaseQueryContext
extends AbstractQueryContext {
    private DatabaseConnection database;

    public DatabaseQueryContext(DatabaseConnection database) {
        this.database = database;
    }

    public Database getDatabase() {
        return this.database.getDatabase();
    }

    public TransactionSystem getSystem() {
        return this.getDatabase().getSystem();
    }

    public FunctionLookup getFunctionLookup() {
        return this.getSystem().getFunctionLookup();
    }

    public GrantManager getGrantManager() {
        return this.database.getGrantManager();
    }

    public DataTable getTable(TableName name) {
        this.database.addSelectedFromTable(name);
        return this.database.getTable(name);
    }

    public DataTableDef getDataTableDef(TableName name) {
        return this.database.getDataTableDef(name);
    }

    public QueryPlanNode createViewQueryPlanNode(TableName name) {
        return this.database.createViewQueryPlanNode(name);
    }

    public long nextSequenceValue(String name) {
        return this.database.nextSequenceValue(name);
    }

    public long currentSequenceValue(String name) {
        return this.database.lastSequenceValue(name);
    }

    public void setSequenceValue(String name, long value) {
        this.database.setSequenceValue(name, value);
    }

    public String getUserName() {
        return this.database.getUser().getUserName();
    }
}

